<?php
require_once(WCF_DIR.'lib/data/user/userpic/Userpic.class.php');
require_once(WCF_DIR.'lib/system/event/EventListener.class.php');

/**
 * @author	Peter Frhwirt
 * @package	de.wbb-security.profile.userpic
 */
class UserPictureListener implements EventListener {
	var $userID = 0; 
	var $user;
	
	/**
	 * @see EventListener::execute()
	 */
	public function execute($eventObj, $className, $eventName) {

		if(MODULE_USERPIC)
		{
			if (isset($_REQUEST['userID'])) $this->userID = intval($_REQUEST['userID']);
			$this->user = new UserProfile($this->userID, null, null, null, null, null);
				
			WCF::getTPL()->assign(array(
								'userpic' => $this->getUserpic(),
								'disableUserpic' => $this->user->disableUserpic
							    ));

			WCF::getTPL()->append('additionalBoxes1', WCF::getTPL()->fetch('userProfilePicture'));
		}
	}
	
	
	/**
	 * Returns the userpic of this user.
	 * 
	 * @return	Userpic
	 */
	public function getUserpic() {
		
		$data = WCF::getDB()->getFirstRow("SELECT * FROM wcf".WCF_N."_user_pictures WHERE userID = ".$this->userID);
		if($data['userpicID'] == 0) {
			return false;
		}
		
		$picture = new Userpic(null, $data);
		return $picture->getPreview();
	}
}


?>